--[[---------------------------------------------------------------------------
	Chocolatier Two Port Data: Jakarta
	Copyright (c) 2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

-------------------------------------------------------------------------------
-- Characters


DefineCharacter { name = "ja_marketkeep" }
DefineCharacter { name = "ja_farmkeep" }
DefineCharacter { name = "ja_otherkeep" }
-------------------------------------------------------------------------------
-- Port Definition

DefinePort
{
	name = "jakarta",
	available = false,
	ambient="sfx/village_loop.ogg",

	layout =
	{
		EmptyBuilding { name="ja_other", character={"sf_tutor"}, ambient="sfx/farm_loop.ogg", x=578+222/2,y=36+70/2 },
		SpriteLayer { image="ja_mountainmask", x=543+257/2,y=77+60/2 },

		-- Planes
		SpriteLayer { imagelist=portPlanes, time=25000,hold=10000,bounce=true,scale=.25,
			path={{-78,12},{176,62},{716,72},{880,49},}, },
		
		-- Clouds
		SpriteLayer { image="clouds_03", time=270000, loop=true, htile=true, path={{0,30},{100,30},{700,30},{800,30}}, },
		SpriteLayer { image="clouds_03", time=240000, loop=true, path={{-400,20},{100,20},{700,20},{1200,20}}, },
		
		SpriteLayer { image="ja_templetop", x=253+31/2,y=49+47/2 },
		Market { name="ja_farm", character="ja_farmkeep", x=0+101/2,y=47+91/2,
			ambient = "sfx/farm_loop.ogg",
			inventory = { ja_cacao=true}, dialog="farm_jakarta", },
		SpriteLayer { image="ja_farmmask", x=0+124/2,y=117+48/2 },

		Shop { name="ja_shop", character="ja_otherkeep", x=172+175/2,y=148+92/2},
		
		-- Traffic
		SpriteLayer { imagelist=portCars, scale=.25, time=18000,hold=5000,bounce=true,
			path={{431,238},{401,237},{121,234},{44,231},}, },
			
		
		SpriteLayer { image="ja_trafficmask", x=0+453/2,y=183+68/2 },
		Market { name="ja_market", character="ja_marketkeep", x=342+411/2,y=83+226/2,
			inventory = { cinnamon=true, coconut=true, cacao=true, macadamia=true, sugar=true, }, },
		SpriteLayer { image="ja_marketmask", x=300+483/2,y=252+94/2 },
		
		--Big Boat
		SpriteLayer { image="boat_03", scale=2.0, time=6000,
			path={{809.04,327},{809.03,332},{809.02,335},{809.01,327},},},
	}
}
